
library(deSolve)
library(FME)
library(ggplot2)
library(readxl)
library(readr)
library(ggpubr)
library(grid)
library(gridExtra)
library(rcompanion)

## setwd to Building Analysis folder

rm(list=ls())

Clean.data <- function(dat){
  
  dat$Children <- cumsum(dat$in_children - dat$exit_children)
  dat$Adults <- cumsum((dat$in_male.adults + dat$in_female.adults) - (dat$exit_male.adults + dat$exit_female.adults))
  
  # format times (to give seconds)
  dat$Time_elapsed <- vapply(dat$Time, function(x) as.numeric(strptime(x, format = "%H:%M:%S")), numeric(1))
  dat$Time_elapsed <- dat$Time_elapsed - dat$Time_elapsed[1]
  
  dat$C_out = 0
  dat <- dat[,-c(1,2,5,6,7,8,9,10,11,12,13)]
  dat <- dat[c(1,6,7,2,3,4,5)]
  
  return <- dat
}
  
Format.data <- function(dat){
  
  colnames(dat) <- c("time","time_elapsed", "C_out", "C_in", "I", "Children","Adults")
  # convert ppm to litres of CO2 per litres of air (by dividing by 1x10^6)
  dat[,c("C_out", "C_in")] <- dat[,c("C_out", "C_in")] / 1e6
  
  dat$IG_adults <- dat$Adults * G_adult 
  dat$IG_children <- dat$Children* G_child 
  dat$IG  <- (dat$IG_adults + dat$IG_children)
  dat$diff_C <- dat$C_in - dat$C_out # difference between inside and outside CO2 concentrations
  
  return <- dat
}

Plot.data <- function(dat){

  p <- ggplot(dat, aes(x = IG, y = diff_C)) + 
    geom_point() +
    geom_smooth(method="lm", formula=y~0+x, se = FALSE) +
    scale_y_continuous(labels=function(x)x*10^6)+
    ylab(expression(paste("Difference in"~CO[2]," (ppm)"))) +
    xlab(expression(paste("Total"~CO[2]," generation rate (l/s)")))+
    theme_bw()+
    theme(text = element_text(size = 8),
          panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
          panel.background = element_blank())
  
  print(p)
  
  #return <- dat
}

G_adult <- 0.00377
G_child <- 0.001975

###############################
######## Church A ######## 
church_df <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchA.csv")

church_df <- Clean.data(church_df)
church_df$C_out = 417
church_df <- Format.data(church_df)
ChurchA_plot <- Plot.data(church_df)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = church_df) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ChurchA', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ChurchA.csv")

######## Church B ######## 
church_df <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchB.csv")

church_df <- Clean.data(church_df)
church_df$C_out = 417
church_df <- Format.data(church_df)
ChurchB_plot <- Plot.data(church_df)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = church_df) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ChurchB', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ChurchB.csv")

######## Church C ######## 
church_df <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchC.csv")

church_df <- Clean.data(church_df)
church_df$C_out = 417
church_df <- Format.data(church_df)
ChurchC_plot <- Plot.data(church_df)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = church_df) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ChurchC', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ChurchC.csv")

######## Church D1 ######## 
church_df <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchD1.csv")

church_df <- Clean.data(church_df)
church_df$C_out = 417
church_df <- Format.data(church_df)
ChurchD1_plot <- Plot.data(church_df)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = church_df) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ChurchD1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ChurchD1.csv")

######## Church D2 ######## 
church_df <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchD2.csv")

church_df <- Clean.data(church_df)
church_df$C_out = 417
church_df <- Format.data(church_df)
ChurchD2_plot <- Plot.data(church_df)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = church_df) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ChurchD2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ChurchD2.csv") 

######## Church E ######## 
church_df <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchE.csv")

church_df <- Clean.data(church_df)
church_df$C_out = 417
church_df <- Format.data(church_df)
ChurchE_plot <- Plot.data(church_df)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = church_df) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ChurchE', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ChurchE.csv")
###############################
Church_plot <- ggarrange(ChurchA_plot, ChurchB_plot ,ChurchC_plot, ChurchD1_plot, ChurchD2_plot, ChurchE_plot,
          ncol = 3, nrow = 2)

annotate_figure(Church_plot, top = text_grob("Church", face = "bold"))

###############################
######## Clinic A1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ClinicA1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ClinicA1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ClinicA1.csv")

######## Clinic A2 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA2.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ClinicA2_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ClinicA2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ClinicA2.csv")

######## Clinic A3 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA3.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ClinicA3_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ClinicA3', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ClinicA3.csv")

######## Clinic A4 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA4.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ClinicA4_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ClinicA4', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ClinicA4.csv")
###############################

Clinic_plot <- ggarrange(ClinicA1_plot, ClinicA2_plot ,ClinicA3_plot, ClinicA4_plot,
          ncol = 2, nrow = 2)

annotate_figure(Clinic_plot, top = text_grob("Clinic", face = "bold"))

###############################
######## Salon A1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonA1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
SalonA1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='SalonA1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/SalonA1.csv")

######## Salon A2 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonA2.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
SalonA2_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='SalonA2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/SalonA2.csv")

######## Salon A3 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonA3.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
SalonA3_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='SalonA3', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/SalonA3.csv")

######## Salon B1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonB1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
SalonB1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='SalonB1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/SalonB1.csv")

######## Salon B2 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonB2.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
SalonB2_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='SalonB2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/SalonB2.csv")

######## Salon B3 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonB3.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
SalonB3_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='SalonB3', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/SalonB3.csv")
###############################

Salon_plot <- ggarrange(SalonA1_plot, SalonA2_plot, SalonA3_plot, SalonB1_plot, SalonB2_plot, SalonB3_plot,
          ncol = 3, nrow = 2)

annotate_figure(Salon_plot, top = text_grob("Salon", face = "bold"))

###############################
######## Shebeen A1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShebeenA1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShebeenA1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShebeenA1.csv")

######## Shebeen A2 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA2.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShebeenA2_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShebeenA2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShebeenA2.csv")

######## Shebeen A3 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA3.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShebeenA3_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShebeenA3', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShebeenA3.csv")

######## Shebeen A4 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA4.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShebeenA4_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShebeenA4', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShebeenA4.csv")

######## Shebeen B1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShebeenB1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShebeenB1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShebeenB1.csv")

######## Shebeen B2 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB2.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShebeenB2_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShebeenB2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShebeenB2.csv")

######## Shebeen B3 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB3.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShebeenB3_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShebeenB3', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShebeenB3.csv")

######## Shebeen B4 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB4.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShebeenB4_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShebeenB4', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShebeenB4.csv")

######## Shebeen B5 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB5.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShebeenB5_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShebeenB5', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShebeenB5.csv")
###############################

Shebeen_plot <- ggarrange(ShebeenA1_plot, ShebeenA2_plot, ShebeenA3_plot, ShebeenA4_plot, ShebeenB1_plot, 
                          ShebeenB2_plot, ShebeenB3_plot, ShebeenB4_plot, ShebeenB5_plot,
                          ncol = 3, nrow = 3)

annotate_figure(Shebeen_plot, top = text_grob("Shebeen", face = "bold"))

###############################
######## Shop A1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopA1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopA1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopA1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopA1.csv")

######## Shop A2 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopA2.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopA2_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopA2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopA2.csv")

######## Shop A3 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopA3.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopA3_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopA3', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopA3.csv")

######## Shop B1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopB1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopB1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopB1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopB1.csv")

######## Shop B2 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopB2.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopB2_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopB2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopB2.csv")

######## Shop C1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopC1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopC1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopC1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopC1.csv")

######## Shop C2 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopC2.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopC2_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopC2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopC2.csv")

######## Shop D1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopD1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopD1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopD1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopD1.csv")

######## Shop D2 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopD2.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopD2_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopD2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopD2.csv")

######## Shop E1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopE1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopE1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopE1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopE1.csv")

######## Shop E2 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopE2.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopE2_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopE2', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopE2.csv")

######## Shop F1 ######## 
data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopF1.csv")

data.frame <- Clean.data(data.frame)
data.frame$C_out = 417
data.frame <- Format.data(data.frame)
ShopF1_plot <- Plot.data(data.frame)

#Regression
lm1 <- lm(formula = IG ~ diff_C + 0, data = data.frame) # constrained linear regression with intercept = 0

Q_guess <- unname(lm1$coefficients)
Q_conf <- confint(lm1)
Q <- round(unname(lm1$coefficients),2)
CI <- round(confint(lm1),2)

#Save
Data.frame <- c(Building='ShopF1', Q=Q, CI=CI)
Data.frame <- t(Data.frame)
write.csv (Data.frame,file="./Q results/ShopF1.csv")

###############################

Shop_plot <- ggarrange(ShopA1_plot, ShopA2_plot, ShopA3_plot, ShopB1_plot, 
          ShopB2_plot, ShopC1_plot, ShopC2_plot, ShopD1_plot, 
          ShopD2_plot, ShopE1_plot, ShopE2_plot, ShopF1_plot,
          ncol = 4, nrow = 3)

annotate_figure(Shop_plot, top = text_grob("Shop", face = "bold"))

############################### Merge files ###############################
Results_Q <- list.files("./Q results/", pattern="\\.csv$", full.names=TRUE)
Results_Q <- lapply(Results_Q, read.csv)
Results_Q <- do.call(rbind, Results_Q)

write.csv (Results_Q,file="./Q results/Results_Q.csv")




